#include <mapandreas>


	//Settings
#if !defined BOMBS
	#define BOMBS 4                     // Amount of bombs in a single load - caution: Can bug up!
#endif

#if !defined LOADS
	#define LOADS 3                     // Amount of loads dropped
#endif

#if !defined AREA
	#define AREA 45                     // Area of Effect in SA-MP units. Square.
#endif

#if !defined MINIMUM_INTERVAL
	#define MINIMUM_INTERVAL 3250       // Minimum interval between loads
#endif

#if !defined EXTRA_MAX_INTERVAL
	#define EXTRA_MAX_INTERVAL 550      // 'Additional' interval between dropped bombs
#endif

#if !defined EXPLOSION_TYPE
	#define EXPLOSION_TYPE 7           // Type of explosion, check the wiki for lists. Standard 7 = HUGE
#endif

#if !defined EXPLOSION_RADIUS
	#define EXPLOSION_RADIUS 8.5        // Explosion radius. I don't really have any effect of it but maybe you do.
#endif

	//End

forward Airstrike_Init();
public Airstrike_Init()
{
	MapAndreas_Init(2);
	print("IT R LOAD!");
}

public OnPlayerDisconnect(playerid, reason)
{
	if(GetPVarInt(playerid, "Airstrike") != 0) KillTimer(GetPVarInt(playerid, "Airstrike") - 1);
	return 1;
}

#if defined _ALS_OnPlayerDisconnect
	#undef OnPlayerDisconnect
#else
	#define _ALS_OnPlayerDisconnect
#endif
#define OnPlayerDisconnect AIRHID_OnPlayerDisconnect
forward AIRHID_OnPlayerDisconnect(playerid, reason);

public OnPlayerKeyStateChange(playerid, newkeys, oldkeys)
{
	if(GetPVarInt(playerid, "Airstrike") != 0 && newkeys & KEY_FIRE && !(oldkeys & KEY_FIRE))
	{
		new Float:Pos[3];
		Pos[0] = GetPVarFloat(playerid, "CamX");
		Pos[1] = GetPVarFloat(playerid, "CamY");
		Pos[2] = GetPVarFloat(playerid, "CamZ");
		SetTimerEx("SetUpAirstrike", 750, 0, "dffd", playerid, Pos[0], Pos[1], LOADS);
		GameTextForPlayer(playerid, "Airstrike inbound!", 1250, 3);
		KillTimer(GetPVarInt(playerid, "Airstrike") - 1);
		DeletePVar(playerid, "Airstrike");
		DeletePVar(playerid, "CamX");
		DeletePVar(playerid, "CamY");
		DeletePVar(playerid, "CamZ");
	}
	return 1;
}

#if defined _ALS_OnPlayerKeyStateChange
	#undef OnPlayerKeyStateChange
#else
	#define _ALS_OnPlayerKeyStateChange
#endif
#define OnPlayerKeyStateChange AIRHID_OnPlayerKeyStateChange
forward AIRHID_OnPlayerKeyStateChange(playerid, newkeys, oldkeys);

forward OnPlayerAirMapUpdate(playerid);
public OnPlayerAirMapUpdate(playerid)
{
	new Keys[3];
	GetPlayerKeys(playerid, Keys[0], Keys[1], Keys[2]);
	
	new Float:Pos[3];
	Pos[0] = GetPVarFloat(playerid, "CamX");
	Pos[1] = GetPVarFloat(playerid, "CamY");
	Pos[2] = GetPVarFloat(playerid, "CamZ");
	Pos[0] += ((Keys[2] > 0) ? ((Keys[0] & KEY_SPRINT) ? (3.6) : (1.8)) : (Keys[2] < 0) ? ((Keys[0] & KEY_SPRINT) ? (-3.6) : (-1.8)) : (0.0));
	Pos[1] += ((Keys[1] < 0) ? ((Keys[0] & KEY_SPRINT) ? (3.6) : (1.8)) : (Keys[1] > 0) ? ((Keys[0] & KEY_SPRINT) ? (-3.6) : (-1.8)) : (0.0));
	SetPlayerCameraPos(playerid, Pos[0], Pos[1], Pos[2]);
	SetPlayerCameraLookAt(playerid, Pos[0], Pos[1] + 0.01, Pos[2] - 1);
	SetPVarFloat(playerid, "CamX", Pos[0]);
	SetPVarFloat(playerid, "CamY", Pos[1]);
	SetPVarFloat(playerid, "CamZ", Pos[2]);
	return 1;
}

stock SetUpPlayerForAirstrike(playerid)
{
	new Float:Pos[3];
	GetPlayerPos(playerid, Pos[0], Pos[1], Pos[2]);
	MapAndreas_FindZ_For2DCoord(Pos[0], Pos[1], Pos[2]);
	Pos[2] += 85;
	SetPlayerCameraPos(playerid, Pos[0], Pos[1], Pos[2] + 85);
	SetPlayerCameraLookAt(playerid, Pos[0], Pos[1], Pos[2] - 1);
	TogglePlayerControllable(playerid, 0);
	SetPVarFloat(playerid, "CamX", Pos[0]);
	SetPVarFloat(playerid, "CamY", Pos[1]);
	SetPVarFloat(playerid, "CamZ", Pos[2]);
	SetPVarInt(playerid, "Airstrike", SetTimerEx("OnPlayerAirMapUpdate", 100, 1, "i", playerid) + 1);
	return 1;
}

forward SetUpAirstrike(playerid, Float:x, Float:y, load);
public SetUpAirstrike(playerid, Float:x, Float:y, load)
{
	if(!load) return;
	if(load == LOADS)
	{
		SetCameraBehindPlayer(playerid);
		TogglePlayerControllable(playerid, 1);
	}
	for(new b; b < BOMBS; b++)
	{
	    SetTimerEx("Bomb", MINIMUM_INTERVAL + random(EXTRA_MAX_INTERVAL), 0, "ff", x, y);
	}
	load--;
	SetTimerEx("SetUpAirstrike", MINIMUM_INTERVAL, 0, "dffd", playerid, x, y, load);
}

forward Bomb(Float:x, Float:y);
public Bomb(Float:x, Float:y)
{
	new Float:z;
	x += random(AREA) - floatdiv(AREA, 2);
	y += random(AREA) - floatdiv(AREA, 2);
	MapAndreas_FindZ_For2DCoord(x, y, z);
	CreateExplosion(x, y, z, EXPLOSION_TYPE, EXPLOSION_RADIUS);
}

/*
native SetUpPlayerForAirstrike(playerid);
native Airstrike_Init();
*/